import { useAppContext } from '../../context/AppContext';
import { useAppDataContext } from '../../context/PluginData';
import ContainerComponent from "../utility/ContainerComponent";
import Header from "../utility/Header";
import { useState, useEffect } from "preact/hooks";
import "ojs/ojinputtext";

export function MergeConditions(props: any) {

    const { setType } = useAppContext();
    const { pluginData } = useAppDataContext();
    const { conditionSet, setConditionSet } = props;
    const [currentIndex, setCurrentIndex] = useState(0);
    const [customText, setCustomText] = useState('');

    const currentCondition = conditionSet[currentIndex] || {};

    useEffect(() => {
        if (currentCondition?.figmaId) {
            parent.postMessage({ pluginMessage: { type: 'select-component', figmaId: currentCondition.figmaId } }, '*');
        }
    }, [currentCondition.figmaId])

    const handleBack = () => {
        setType('updateConditions');
    }

    const handleNext = () => {
        setConditionSet((prevState: any) =>
            prevState.map((item: any) =>
                item.figmaId === currentCondition.figmaId ? { ...item, updateCondition:customText, name: pluginData?.pluginSelectedComponent} : item
            )
        );

        if (currentIndex < conditionSet.length - 1) {
            setCurrentIndex(prevIndex => prevIndex + 1);
        } else {
            setType('mergeSummary')
        }
        
        setCustomText('');
    }

    const handlePrevious = () => {
        if (currentIndex > 0) {
            setCurrentIndex(currentIndex - 1);
        }
        setConditionSet((prevState: any) =>
            prevState.map((item: any) =>
                item.figmaId === currentCondition.figmaId ? { ...item, customText } : item
            )
        );
        setCustomText('');
    }

    const handleOld = () => {
        setCustomText(currentCondition.old);
    }

    const handleNew = () => {
        setCustomText(currentCondition.new);
    }

    const handleAnd = () => {
        setCustomText(`${currentCondition.old || ''}${currentCondition.old && currentCondition.new ? ' && ' : ''}${currentCondition.new || ''}`);
    }

    const handleOr = () => {
        setCustomText(`${currentCondition.old || ''}${currentCondition.old && currentCondition.new ? ' || ' : ''}${currentCondition.new || ''}`);
    }

    return (
        <>
            <ContainerComponent>
                <Header title='Add Condition' handleBack={handleBack} />
                <oj-input-text
                    id="componentName"
                    value={pluginData?.pluginSelectedComponent}
                    label-hint="Condition Component"
                    label-edge="inside"
                    readonly
                    class="oj-sm-margin-4x-bottom"
                ></oj-input-text>

                <div style={{ display: 'flex', flex: '1', flexDirection: 'row', marginBottom: '16px' }}>
                    <div style={{ flex: '1', padding: '8px', border: '1px solid #ccc', wordBreak: 'break-word' }}>
                        {currentCondition.old}
                    </div>
                    <div style={{ flex: '1', padding: '8px', border: '1px solid #ccc', marginLeft: '8px', wordBreak: 'break-word' }}>
                        {currentCondition.new}
                    </div>
                </div>

                <div style={{ display: 'flex', flexDirection: 'row', marginBottom: '16px', justifyContent: 'space-between' }}>
                    <oj-button style={{ flex: 1, marginRight: '8px' }} class="oj-button-md" chroming="outlined" label="Old" onojAction={handleOld} />
                    <oj-button style={{ flex: 1, marginLeft: '8px' }} class="oj-button-md" chroming="outlined" label="New" onojAction={handleNew} />
                </div>

                <div style={{ display: 'flex', flexDirection: 'row', marginBottom: '16px', justifyContent: 'space-between' }}>
                    <oj-button style={{ flex: 1, marginRight: '8px' }} class="oj-button-md" chroming="outlined" label="AND" onojAction={handleAnd} />
                    <oj-button style={{ flex: 1, marginLeft: '8px' }} class="oj-button-md" chroming="outlined" label="OR" onojAction={handleOr} />
                </div>


                <oj-input-text
                    id="customText"
                    label-hint="Custom Text"
                    label-edge="inside"
                    value={customText}
                    class="oj-sm-margin-12x-bottom"
                    onvalueChanged={(event) => setCustomText(event.detail.value)} ></oj-input-text>

                <div style={{ position: 'fixed', bottom: 8, left: 8, right: 8, padding: 0, display: 'flex', justifyContent: 'space-between' }}>
                    <oj-button style={{ flex: 1, marginRight: '8px' }} class="oj-button-md" disabled={currentIndex === 0} chroming="outlined" label="Previous" onojAction={handlePrevious} />
                    <oj-button
                        style={{ flex: 1, marginLeft: '8px' }}
                        class="oj-button-md"
                        chroming="callToAction"
                        label={currentIndex >= conditionSet.length - 1 ? 'Submit' : 'Next'}
                        onojAction={handleNext}
                    />
                </div>

            </ContainerComponent>
        </>
    )
}