import ContainerComponent from "../utility/ContainerComponent";
import Header from "../utility/Header";
import { useAppContext } from '../../context/AppContext';
import { useAppDataContext } from "../../context/PluginData";
import "ojs/ojbutton";
import "ojs/ojfilepicker";
import "ojs/ojcheckboxset";
import "ojs/ojlabel";
import "ojs/ojlabelvalue";
import "ojs/ojinputtext";
import "ojs/ojselectcombobox";
import { ojCheckboxset } from "ojs/ojcheckboxset";
import * as FilePickerUtils from "ojs/ojfilepickerutils";
import ArrayDataProvider = require("ojs/ojarraydataprovider");
import ButtonComponent from "../utility/Button";

export function ExportForm() {
    const { setType, formData, setFormData } = useAppContext();
    const { pluginData } = useAppDataContext();

    //add in map file
    const userOptions = [
        { value: 'retail', label: 'Retail' },
        { value: 'corporate', label: 'Corporate' },
        { value: 'admin', label: 'Admin' },
    ]

    const userOptionsArrayProvider = new ArrayDataProvider(userOptions, {
        keyAttributes: "value",
    })


    const handleBack = () => {

        setFormData({
            ...formData,
            componentType: 'SINGLE_PAGE',
            componentName: '',
            componentDescription: '',
            usableComponent: false,
            moduleName: '',
            moduleDescription: '',
            menuEntry: false,
            readOnly: false,
            userType: []
        });
        setType('mainPage');
    }

    const handleFileChange = (event: any) => {
        const filePath = event.detail?.files[0]?.path;
        if (filePath) {
            const finalPath = filePath.replace(/[\\/][^\\/]+$/, '');
            parent.postMessage({ pluginMessage: { path: 'trunk', finalPath } }, '*');
            setFormData({
                ...formData,
                trunkPath: finalPath
            });
        } else {
            console.log('The "trunk" folder is not found in the path.');
        }
    }

    const buttonFilePicker = (event: any) => {
        FilePickerUtils.pickFiles(selectListener, {
            accept: [],
            capture: "none",
            selectionMode: "single",
        });
    }

    const selectListener = (files: any) => {
        const filePath = files[0]?.path;
        if (filePath) {
            const finalPath = filePath.replace(/[\\/][^\\/]+$/, '');
            parent.postMessage({ pluginMessage: { path: 'trunk', finalPath } }, '*');
            setFormData({
                ...formData,
                trunkPath: finalPath
            });
        } else {
            console.log('The "trunk" folder is not found in the path.');
        }
    }

    const handleCheckboxChange = (
        event: ojCheckboxset.valueChanged<string, Array<string>, Array<string>>,
        key: keyof typeof formData
    ) => {
        setFormData({ ...formData, [key]: event.detail.value!.length > 0 });
    };

    const handleUserTypeChange = (event: any, type: string) => {
        setFormData({
            ...formData,
            [type]: event.detail.value
        });
    };

    const handleChange = (event: any) => {
        const name = event.currentTarget.id;
        const value = event.detail.value;
        if (name === 'componentDescription') {
            const updatedValue = value
                .toLowerCase()
                .split(' ')
                .join('-');
            setFormData({
                ...formData,
                [name]: value,
                componentName: updatedValue,
            });
        } else if (name === 'moduleDescription') {
            const updatedValue = value
                .toLowerCase()
                .split(' ')
                .join('-');
            setFormData({
                ...formData,
                [name]: value,
                moduleName: updatedValue,
            });
        } else {
            setFormData({
                ...formData,
                [name]: value,
            });
        }
    }

    const handleExport = () => {
        if(pluginData?.error && pluginData?.error === 'export') {
            console.log('Error in Export');
            return;
        }
        if (!formData.menuEntry) {
            if (formData.componentType === 'SINGLE_PAGE' && formData.usableComponent) {
                setFormData({
                    ...formData
                });
            }
            parent.postMessage({ pluginMessage: { type: 'export-proceed', formData } }, '*');
            setType('exportProceed');
        } else {
            setType('exportMenuEntry');
        }
    }

    return (
        <>
            <ContainerComponent>
                <Header title='Export to Toolkit' handleBack={handleBack} />
                <div style={{ overflowY: 'auto', flex: 1, marginBottom: '50px' }}>
                    {formData.trunkPath === '' ? (
                        <div style={{ height: '100px', marginBottom: '10px' }}>
                            <oj-file-picker
                                selectionMode="single"
                                class=""
                                primaryText='Select Trunk Path'
                                secondaryText='Choose the package.json file from the trunk directory'
                                onojSelect={handleFileChange}></oj-file-picker>
                        </div>
                    ) : (
                        <>
                            <oj-input-text
                                id="workspacePath"
                                label-hint="Workspace Path"
                                label-edge="inside"
                                class="oj-sm-margin-2x-bottom"
                                value={formData?.trunkPath}
                                readonly>
                                <oj-button
                                    slot="end"
                                    display="icons"
                                    onojAction={buttonFilePicker}
                                    chroming="borderless">
                                    <span slot="endIcon" class="oj-ux-ico-edit"></span>
                                </oj-button>
                            </oj-input-text>
                        </>
                    )}
                    <oj-label-value>
                        <oj-label id="exportlabelid" slot="label">Select the action you would like to perform</oj-label>
                    </oj-label-value>
                    <oj-buttonset-one
                        id="exportOptions"
                        value={formData.componentType}
                        onvalueChanged={(event) => handleUserTypeChange(event, 'componentType')}
                        class="oj-button-sm oj-sm-margin-1x-bottom">
                        <oj-option value='SINGLE_PAGE'>
                            <span>Individual Page</span>
                        </oj-option>
                        <oj-option value='FLOW'>
                            <span>Transaction</span>
                        </oj-option>
                        <oj-option value='WIDGET'>
                            <span>Widget</span>
                        </oj-option>
                        <oj-option value='OVERVIEW'>
                            <span>Overview</span>
                        </oj-option>
                    </oj-buttonset-one>

                    <div class='oj-flex oj-sm-flex-direction-row'>

                        {formData?.componentType === 'SINGLE_PAGE' && (
                            <oj-checkboxset
                                id="usableComponentId"
                                onvalueChanged={(event) => handleCheckboxChange(event, 'usableComponent')}>
                                <oj-option value={formData.usableComponent}>Usable Component?</oj-option>
                            </oj-checkboxset>
                        )}

                        {formData.usableComponent && formData?.componentType === 'SINGLE_PAGE' && formData?.usableComponent && (
                            <oj-checkboxset
                                id="readOnlyComponentId"
                                onvalueChanged={(event) => handleCheckboxChange(event, 'readOnly')}
                                class="oj-sm-margin-4x-start">
                                <oj-option value={formData.readOnly}>Read Only?</oj-option>
                            </oj-checkboxset>
                        )}
                    </div>

                    <div class='oj-flex oj-sm-flex-direction-row oj-sm-margin-1x-bottom'>
                        <oj-checkboxset
                            id="menuEntryId"
                            onvalueChanged={(event) => handleCheckboxChange(event, 'menuEntry')}>
                            <oj-option value={formData.menuEntry}>Add in Menu?</oj-option>
                        </oj-checkboxset>
                    </div>

                    {formData.menuEntry && (
                        <oj-combobox-many
                            id="userComboBox"
                            class="oj-form-control-max-width-md oj-sm-margin-2x-bottom"
                            label-hint="Select type of user"
                            label-edge="inside"
                            value={formData.userType}
                            onvalueChanged={(event) => handleUserTypeChange(event, 'userType')}
                            required
                            options={userOptionsArrayProvider}></oj-combobox-many>
                    )}

                    {formData.componentType !== 'FLOW' && formData?.componentType !== 'OVERVIEW' && (
                        <oj-input-text
                            id="moduleDescription"
                            label-hint="Module Description"
                            label-edge="inside"
                            value={formData.moduleDescription}
                            class="demo-form-control-max-width oj-sm-margin-2x-bottom"
                            required
                            onvalueChanged={handleChange}></oj-input-text>
                    )}
                    {formData.moduleDescription !== '' && formData.componentType !== 'FLOW' && formData?.componentType !== 'OVERVIEW' && (
                        <oj-input-text
                            id="moduleName"
                            label-hint="Module Name"
                            label-edge="inside"
                            value={formData.moduleName}
                            class="demo-form-control-max-width oj-sm-margin-3x-bottom"
                            readonly ></oj-input-text>
                    )}
                    <oj-input-text
                        id="componentDescription"
                        label-hint={formData.componentType === 'FLOW' ? 'Transaction Description' : 'Component Description'}
                        label-edge="inside"
                        value={formData.componentDescription}
                        class="demo-form-control-max-width oj-sm-margin-2x-bottom"
                        required
                        onvalueChanged={handleChange}></oj-input-text>

                    {formData.componentDescription !== '' && (
                        <oj-input-text
                            id="componentName"
                            label-hint={formData.componentType === 'FLOW' ? 'Transaction Name' : 'Component Name'}
                            label-edge="inside"
                            value={formData.componentName}
                            class="demo-form-control-max-width"
                            readonly />
                    )}
                </div>
                <ButtonComponent
                    label='Proceed'
                    onClick={handleExport}
                    disabled={false}
                />
            </ContainerComponent>
        </>
    )
}