import { useState } from "preact/hooks";
import ContainerComponent from "../utility/ContainerComponent";
import ButtonComponent from "../utility/Button";
import { useAppContext } from '../../context/AppContext';
import ArrayDataProvider = require("ojs/ojarraydataprovider");
import "ojs/ojselectsingle";
import "ojs/ojbutton";
import Header from "../utility/Header";

interface ComponentData {
    value: string;
    label: string;
}

export function Create() {
    const { setType } = useAppContext();
    const [selectedComponent, setSelectedComponent] = useState<string>('');
    const [selectedType, setSelectedType] = useState<string>('');

    const componentData: ComponentData[] = [
        { value: "pageSection", label: "Form" },
        { value: "overview", label: "Overview"}
    ];

    const componentArrayProvider = new ArrayDataProvider(componentData, {
        keyAttributes: "value",
    })

    const pageSectionData: ComponentData[] = [
        { value: "1", label: "1" },
        { value: "2", label: "2" },
        { value: "3", label: "3" },
        { value: "4", label: "4" },
        { value: "5", label: "5" },
        { value: "6", label: "6" },
        { value: "7", label: "7" },
    ]

    const pageSectionsArrayProvider = new ArrayDataProvider(pageSectionData, {
        keyAttributes: "value",
    })

    const handleComponentChange = (event: CustomEvent) => {
        setSelectedComponent(event.detail.value);
    };

    const handleTypeChange = (event: CustomEvent) => {
        setSelectedType(event.detail.value);
    };

    const handleCreate = () => {
        const cloneComponent = {
            component: selectedComponent,
            type: selectedType
        }
        parent.postMessage({ pluginMessage: { type: 'create-clone', cloneComponent } }, '*');
    };


    const handleBack = () => {
        setType('mainPage')
    }

    return (
        <>
            <ContainerComponent>
                <Header title='Create New Design' handleBack={handleBack} />
                <div>
                    <oj-select-single
                        id="select1"
                        label-hint="Select a component"
                        label-edge="inside"
                        class="oj-form-control-max-width-md"
                        data={componentArrayProvider}
                        value={selectedComponent}
                        onvalueChanged={handleComponentChange}></oj-select-single>

                    {(selectedComponent === 'pageSection' || selectedComponent === 'overview') && (
                        <oj-select-single
                            id="select2"
                            label-hint={selectedComponent === 'pageSection'?"No. of Sections":"No. of Overview Sections"}
                            label-edge="inside"
                            class="oj-form-control-max-width-md oj-sm-margin-3x-top"
                            data={pageSectionsArrayProvider}
                            value={selectedType}
                            onvalueChanged={handleTypeChange}></oj-select-single>
                    )}
                </div>
                <ButtonComponent label='Proceed' onClick={handleCreate} disabled={false}/>

            </ContainerComponent>
        </>
    )
}