import { useState, useEffect } from "preact/hooks";
import { useAppContext } from '../../context/AppContext';
import { useAppDataContext } from "../../context/PluginData";
import ArrayDataProvider = require("ojs/ojarraydataprovider");
import "ojs/ojselectsingle";
import "ojs/ojbutton";
import ContainerComponent from "../utility/ContainerComponent";
import Header from "../utility/Header";
import ButtonComponent from "../utility/Button";

export function AddCondition() {

    const { setType } = useAppContext();
    const { pluginData, setPluginData } = useAppDataContext();
    const conditionComponent1 = pluginData?.conditionComponent1;
    const conditionComponent2 = pluginData?.conditionComponent2;
    const [component1PropertyData, setComponent1PropertyData] = useState();
    const [component1PropertyValueData, setComponent1PropertyValueData] = useState(null);
    const [component2PropertyData, setComponent2PropertyData] = useState<ArrayDataProvider<any, any> | undefined>(undefined);
    const [component2PropertyValueData, setComponent2PropertyValueData] = useState(null);
    const [component2ValueData, setComponent2ValueData] = useState<ArrayDataProvider<any, any> | undefined>(undefined);

    const initialComponentState = {
        variableComponentId: conditionComponent1.id,
        variableComponentName: conditionComponent1.name,
        variableComponentTo: 'component',
        variableProperty: '',
        variablePropertyValue: '',
        conditionType: 'show',
        controllingComponentId: '',
        controllingComponentName: '',
        controllingComponentFrom: 'component',
        controllingProperty: '',
        controllingPropertyValue: '',
        controllingComponentValue: ''
    }

    const [componentDetails, setComponentDetails] = useState(initialComponentState);

    useEffect(() => {
        if (conditionComponent1 && conditionComponent1.propertiesDetails) {
            const component1Properties: any = Object.keys(conditionComponent1.propertiesDetails).map(key => ({ value: key, label: key }));
            const component1PropertiesArrayProvider: any = new ArrayDataProvider(component1Properties, {
                keyAttributes: "value",
            })
            setComponent1PropertyData(component1PropertiesArrayProvider);
        }
    }, [conditionComponent1]);

    useEffect(() => {
        if (conditionComponent2) {
            setComponentDetails({
                ...componentDetails,
                controllingComponentName: conditionComponent2.name,
                controllingComponentId: conditionComponent2.id
            });

            const component2Value = conditionComponent2.componentValueDetails.map((str: string) => ({
                value: str.replace(/\s+/g, '').toLowerCase(),
                label: str
            }));
            const component2ValueArrayProvider = new ArrayDataProvider(component2Value, {
                keyAttributes: "value",
            });
            setComponent2ValueData(component2ValueArrayProvider);

            if (Object.keys(conditionComponent2.propertiesDetails).length > 0) {
                const component2Properties = Object.keys(conditionComponent2.propertiesDetails).map(key => ({ value: key, label: key }));
                const component2PropertiesArrayProvider = new ArrayDataProvider(component2Properties, {
                    keyAttributes: "value",
                });
                setComponent2PropertyData(component2PropertiesArrayProvider);

            }
        }
    }, [conditionComponent2]);

    const handleComponent1PropertyChange = (event: any) => {
        setComponentDetails({
            ...componentDetails,
            variableProperty: event.detail.value,
            variablePropertyValue: '',
        });
        let output: any = [];
        const selectedProperty = conditionComponent1.propertiesDetails[event.detail.value];
        if (Array.isArray(selectedProperty)) {
            output = selectedProperty.map(option => ({ value: option, label: option }));
            const component1PropertyValueArrayProvider: any = new ArrayDataProvider(output, {
                keyAttributes: "value",
            })
            setComponent1PropertyValueData(component1PropertyValueArrayProvider);
        } else {
            setComponent1PropertyValueData(null);
        }
    };

    const handleComponent2PropertyChange = (event: any) => {
        setComponentDetails({
            ...componentDetails,
            controllingProperty: event.detail.value,
            controllingPropertyValue: '',
            controllingComponentValue: ''
        });
        let output: any = [];
        const selectedProperty = conditionComponent2.propertiesDetails[event.detail.value];
        if (Array.isArray(selectedProperty)) {
            output = selectedProperty.map(option => ({ value: option, label: option }));
            const component2PropertyValueArrayProvider: any = new ArrayDataProvider(output, {
                keyAttributes: "value",
            })
            setComponent2PropertyValueData(component2PropertyValueArrayProvider);
        } else {
            setComponent2PropertyValueData(null);
        }
    };

    const handleComponent1PropertyValueChange = (event: any) => {
        setComponentDetails({
            ...componentDetails,
            variablePropertyValue: event.detail.value
        });
    };

    const handleComponent2PropertyValueChange = (event: any) => {
        setComponentDetails({
            ...componentDetails,
            controllingPropertyValue: event.detail.value,
            controllingComponentValue: ''
        });
    };

    const handleComponent2ValueChange = (event: any) => {
        setComponentDetails({
            ...componentDetails,
            controllingPropertyValue: '',
            controllingProperty: '',
            controllingComponentValue: event.detail.value
        });
    };

    const conditionTypeActionHandler = (event: any) => {
        setComponentDetails({
            ...componentDetails,
            conditionType: event.detail.value
        });
    }

    const variableComponentToActionHandler = (event: any) => {
        setComponentDetails({
            ...componentDetails,
            variableComponentTo: event.detail.value,
            variableProperty: '',
            variablePropertyValue: '',
        });
    }

    const controllingComponentFromActionHandler = (event: any) => {
        setComponentDetails({
            ...componentDetails,
            controllingComponentFrom: event.detail.value,
            controllingProperty: '',
            controllingPropertyValue: '',
            controllingComponentValue: ''
        });
    }

    const handleSave = () => {
        if (componentDetails.controllingComponentName !== '' && componentDetails.controllingComponentId !== '') {
            setPluginData({
                ...pluginData,
                conditionComponent2: undefined,
            });
            setComponentDetails(initialComponentState);
            parent.postMessage({ pluginMessage: { type: 'save-condition-data', componentDetails } }, '*');
            setType('conditionSuccess');
        }
    }

    const fetchControllingComponent = () => {
        parent.postMessage({ pluginMessage: { type: 'fetch-controlling-component' } }, '*');
    }

    const handleBack = () => {
        if (conditionComponent2) {
            setPluginData({
                ...pluginData,
                conditionComponent2: undefined,
            });
        }
        setComponentDetails(initialComponentState);
        setType('generate')
        parent.postMessage({ pluginMessage: { type: 'generate' } }, '*');
    }

    console.log('cpd', component2PropertyData);
    return (
        <>
            <ContainerComponent>
                <Header title='Add Condition' handleBack={handleBack} />
                <div class="oj-flex" style={{ display: 'flex', alignItems: 'stretch' }}>
                    <div class="oj-flex-item oj-sm-flex-direction-column oj-sm-padding-2x-end" style={{ width: 'calc(50% - 4px)', borderRight: "thin solid #DEDEDE" }}>
                        <div style={{ backgroundColor: 'rgba(130, 91, 189, 0.10)', padding: '4px', borderRadius: '4px', border: '1px solid rgba(22, 21, 19, 0.12)', marginBottom: '8px' }}>
                            <oj-input-text
                                id="componentName"
                                value={componentDetails.variableComponentName}
                                label-hint="Variable Component"
                                label-edge="inside"
                                readonly
                                class=""
                            ></oj-input-text>
                        </div>
                        {/* label can be added in common component */}
                        <oj-label-value>
                            <oj-label id="variableTypeId" slot="label">Apply Condition To</oj-label>
                        </oj-label-value>
                        <oj-buttonset-one
                            id="conditionTo"
                            labelled-by="conditionToId"
                            value={componentDetails.variableComponentTo}
                            onvalueChanged={variableComponentToActionHandler}
                            class="oj-button-sm oj-sm-margin-4x-bottom">
                            <oj-option value='component'>
                                <span>Component</span>
                            </oj-option>
                            <oj-option value='property' disabled={component1PropertyData === null || component1PropertyData === undefined}>
                                <span>Property</span>
                            </oj-option>
                        </oj-buttonset-one>

                        {componentDetails.variableComponentTo === 'property' && (
                            <oj-select-single
                                id="select1"
                                label-hint="Select a Property"
                                label-edge="inside"
                                class="oj-form-control-max-width-md oj-sm-margin-4x-bottom"
                                data={component1PropertyData}
                                value={componentDetails.variableProperty}
                                onvalueChanged={handleComponent1PropertyChange}
                            ></oj-select-single>
                        )}

                        {component1PropertyValueData && componentDetails.variableComponentTo === 'property' && (
                            <oj-select-single
                                id="select2"
                                label-hint="Property Value"
                                label-edge="inside"
                                class="oj-form-control-max-width-md oj-sm-margin-4x-bottom"
                                data={component1PropertyValueData}
                                value={componentDetails.variablePropertyValue}
                                onvalueChanged={handleComponent1PropertyValueChange}
                            ></oj-select-single>
                        )}

                        <oj-label-value>
                            <oj-label id="conditionTypeId" slot="label">Condition Type</oj-label>
                        </oj-label-value>
                        <oj-buttonset-one
                            id="conditionType"
                            labelled-by="conditionTypeId"
                            value={componentDetails.conditionType}
                            onvalueChanged={conditionTypeActionHandler}
                            class="oj-button-sm">
                            <oj-option value='show'>
                                <span>Show</span>
                            </oj-option>
                            <oj-option value='hide'>
                                <span>Hide</span>
                            </oj-option>
                        </oj-buttonset-one>

                    </div>
                    <div class="oj-flex-item oj-sm-flex-direction-column oj-sm-margin-2x-start" style={{ width: 'calc(50% - 4px)' }}>
                        {!conditionComponent2 && (
                            <oj-button class="oj-button-md oj-button-full-width" id="width_full_button" chroming="borderless" label="Select the Controlling component" style={{ border: "2px dashed black" }} onojAction={fetchControllingComponent} />
                        )}
                        {conditionComponent2 && (
                            <>
                                <div style={{ backgroundColor: 'rgba(78, 124, 70, 0.1)', padding: '4px', borderRadius: '4px', border: '1px solid rgba(78, 124, 70)', marginBottom: '8px' }}>
                                    <oj-input-text
                                        id="componentName"
                                        value={componentDetails.controllingComponentName}
                                        label-hint="Controlling Component"
                                        label-edge="inside"
                                        readonly
                                        class=""
                                    >
                                    </oj-input-text>
                                </div>
                                {/* label can be added in common component */}
                                <oj-label-value>
                                    <oj-label id="controllingTypeId" slot="label">Apply Condition From</oj-label>
                                </oj-label-value>
                                <oj-buttonset-one
                                    id="conditionFrom"
                                    labelled-by="conditionFromId"
                                    value={componentDetails.controllingComponentFrom}
                                    onvalueChanged={controllingComponentFromActionHandler}
                                    class="oj-button-sm oj-sm-margin-4x-bottom">
                                    <oj-option value='component'>
                                        <span>Component</span>
                                    </oj-option>
                                    <oj-option value='property' disabled={component2PropertyData === null || component2PropertyData === undefined}>
                                        <span>Property</span>
                                    </oj-option>
                                </oj-buttonset-one>

                                {componentDetails.controllingComponentFrom === 'component' && (
                                    <oj-select-single
                                        id="select5"
                                        label-hint="Component Value"
                                        label-edge="inside"
                                        class="oj-form-control-max-width-md oj-sm-margin-4x-bottom"
                                        data={component2ValueData}
                                        value={componentDetails.controllingComponentValue}
                                        onvalueChanged={handleComponent2ValueChange}
                                    ></oj-select-single>
                                )}

                                {componentDetails.controllingComponentFrom === 'property' && (
                                    <oj-select-single
                                        id="select3"
                                        label-hint="Select a Property"
                                        label-edge="inside"
                                        class="oj-form-control-max-width-md oj-sm-margin-4x-bottom"
                                        data={component2PropertyData}
                                        value={componentDetails.controllingProperty}
                                        onvalueChanged={handleComponent2PropertyChange}
                                    ></oj-select-single>
                                )}

                                {component2PropertyValueData && componentDetails.controllingComponentFrom === 'property' && (
                                    <oj-select-single
                                        id="select4"
                                        label-hint="Property Value"
                                        label-edge="inside"
                                        class="oj-form-control-max-width-md oj-sm-margin-4x-bottom"
                                        data={component2PropertyValueData}
                                        value={componentDetails.controllingPropertyValue}
                                        onvalueChanged={handleComponent2PropertyValueChange}
                                    ></oj-select-single>
                                )}
                            </>
                        )}
                    </div>
                </div>

                <div style={{
                    position: 'fixed', bottom: 62, left: 8, right: 8, padding: 8, backgroundColor: '#FFFFFF', border: '1px solid', display: 'flex',
                    alignItems: 'center',
                    justifyContent: 'space-between'
                }}>
                    <div>
                        Connection:
                        <span style={{ color: '#4E7C46' }}> {componentDetails.controllingComponentName}</span>
                        {componentDetails.controllingProperty && (
                            <span style={{ color: '#4E7C46' }}> → {componentDetails.controllingProperty}</span>
                        )}
                        {componentDetails.controllingProperty && componentDetails.controllingPropertyValue && (
                            <span style={{ color: '#4E7C46' }}> → {componentDetails.controllingPropertyValue}</span>
                        )}
                        {componentDetails.controllingComponentValue && (
                            <span style={{ color: '#4E7C46' }}> → {componentDetails.controllingComponentValue}</span>
                        )}
                        {componentDetails.variableComponentName && (
                            <span style={{ color: '#825BBD' }}> → {componentDetails.variableComponentName}</span>
                        )}
                        {componentDetails.variableProperty && (
                            <span style={{ color: '#825BBD' }}> → {componentDetails.variableProperty}</span>
                        )}
                        {componentDetails.variableProperty && componentDetails.variablePropertyValue && (
                            <span style={{ color: '#825BBD' }}> → {componentDetails.variablePropertyValue}</span>
                        )}
                        {/* <span style={{ color: '#825BBD' }}> {componentDetails.variableComponentName}</span>
                        {componentDetails.variableProperty && (
                            <span style={{ color: '#825BBD' }}> → {componentDetails.variableProperty}</span>
                        )}
                        {componentDetails.variableProperty && componentDetails.variablePropertyValue && (
                            <span style={{ color: '#825BBD' }}> → {componentDetails.variablePropertyValue}</span>
                        )}
                        {componentDetails.controllingComponentName && (
                            <span style={{ color: '#4E7C46' }}> → {componentDetails.controllingComponentName}</span>
                        )}
                        {componentDetails.controllingProperty && (
                            <span style={{ color: '#4E7C46' }}> → {componentDetails.controllingProperty}</span>
                        )}
                        {componentDetails.controllingProperty && componentDetails.controllingPropertyValue && (
                            <span style={{ color: '#4E7C46' }}> → {componentDetails.controllingPropertyValue}</span>
                        )}
                        {componentDetails.controllingComponentValue && (
                            <span style={{ color: '#4E7C46' }}> → {componentDetails.controllingComponentValue}</span>
                        )} */}
                    </div>

                    {componentDetails.conditionType === 'show' && (
                        <span class="oj-ux-ico-view oj-ux-icon-size-5x" role="img" aria-label="show"></span>
                    )}

                    {componentDetails.conditionType === 'hide' && (
                        <span class="oj-ux-ico-view-hide oj-ux-icon-size-5x" role="img" aria-label="hide"></span>
                    )}

                </div>
                <ButtonComponent label='Save' onClick={handleSave} disabled={false} />

            </ContainerComponent>
        </>
    )
}