import { registerCustomElement } from "ojs/ojvcomponent";
import { useEffect } from "preact/hooks";
import Context = require("ojs/ojcontext");
import { AppProvider } from "../context/AppContext";
import { AppDataProvider } from "../context/PluginData";
import { MainContainer } from "./content/mainContainer";

export const App = registerCustomElement(
    "app-root",
    () => {
        useEffect(() => {
            Context.getPageContext().getBusyContext().applicationBootstrapComplete();
        }, []);

        return (
            <AppProvider>
                <AppDataProvider>
                    <div id="appContainer" >
                        <MainContainer />
                    </div>
                </AppDataProvider>
            </AppProvider>
        );
    }
);
