import { generate } from "./cleanFunc";
import { parentFlexType } from "./flexFunc";
import { handleFlowComponent, processFlowComponent } from "./processFlow";
import { modalWindows } from "./toolkitComponents";
import { addAttributes, traverseNode } from "./traverseNode";

interface compProp {
  [key: string]: any;
}

let formData: any;
let nodeId: string = '';



function processSinglePageComponent(node: any): any[] {
  const flexParent = node.layoutMode !== 'NONE';

  const children = (node.children?.flatMap(traverseNode, true, flexParent) || []).filter((child: any) => Object.keys(child).length > 0);

  if (children.length === 0) {
    return [];
  }

  const frameResult: compProp = {
    type: "Container",
    componentID: `'${generate()}'`,
    figmaId: node.id,
    containerType: "NormalContainer",
    children,
  };
  const flex = node.getPluginData("flexExists");
  if (flex === 'yes') {
    const flex = {
      "colon": true,
      "attribute": "class",
      "value": `'oj-flex oj-flex-items-pad'`
    };
    frameResult.customAttribute = addAttributes(frameResult.customAttribute, flex);
  } else if (node.layoutMode !== 'NONE') {
    const flexType = parentFlexType(node);
    const flex = {
        "colon": true,
        "attribute": "class",
        "value": `'oj-flex${flexType}'`
    };
    frameResult.customAttribute = addAttributes(frameResult.customAttribute, flex);
}
  return [frameResult];
}

function processDefaultComponent(node: any): any[] {
  const output = traverseNode(node);
  let result: any[] = [];
  if (Array.isArray(output)) {
    result.push(...output);
  } else if (output && Object.keys(output).length > 0) {
    result.push(output);
  }
  return result
}

export function mainFunction(node: any, projectForm: any) {
  formData = projectForm;
  nodeId = node?.id;
  const componentType = projectForm?.componentType;
  const pageType = (componentType === 'FLOW')
    ? 'FLOW'
    : (componentType === 'SINGLE_PAGE' && projectForm.usableComponent)
      ? 'BUSINESS'
      : 'SINGLE';

  const ignoreNode: any[] = [];
  const customNLS: any[] = [];

  node?.setPluginData("ignoreNode", JSON.stringify(ignoreNode));
  node?.setPluginData("customNLS", JSON.stringify(customNLS));

  let result: any[] = [];

  switch (pageType) {
    case 'FLOW':
      handleFlowComponent(node);
      result = processFlowComponent(node);
      break;

    case 'SINGLE':
      result = processDefaultComponent(node);
      break;

    case 'BUSINESS':
      result = processSinglePageComponent(node);
      break;

    default:
      result = processDefaultComponent(node);
      break;
  }

  result = result.concat(modalWindows());
  node?.setPluginData("ignoreNode", JSON.stringify(ignoreNode));
  console.log(result);
  return result;
}

export function formDataFunc() {
  return formData;
}

export function updateFormData(newFormData: any){
  formData = newFormData;
}

export function setNodeIdFunc(currentNodeId: string) {
  nodeId = currentNodeId;
}

export function getNodeIdFunc() {
  return nodeId;
}

