import { generate } from "./cleanFunc";
import { formDataFunc } from "./processFunc";
import { traverseNode } from "./traverseNode";

export function handleFlowComponent(node: any) {
    const reviewType = node.componentProperties['Review Type'].value;
    formDataFunc().transactionReviewType = (reviewType === 'Default') ? 'Default' : 'Custom';
}

export function processFlowComponent(node: any): any[] {
    const flowResult = flowBody(node);
    return flowResult.filter((value: any) => Object.keys(value).length !== 0);
}

function processButton(buttons: any, defaultName: string) {
    const buttonOutput: any = {
        nameholder: defaultName,
        selectionType: "custom",
        buttonName: buttons.buttonName,
        valueClasses: "''",
        type: 'Contract',
        componentID: buttons.componentID,
        figmaId: buttons.figmaId
    };

    if (buttons.nameholder !== defaultName) {
        buttonOutput.contract = { label: buttons.nameholder };
    }

    return buttonOutput;
}

export function flowBody(node: any) {
    try {
        if (!node) {
            throw new Error("The 'node' parameter is missing or undefined in extract Text from Node.");
        }

        let output: any[] = [];
        const initiationNode = node.children.find((child: any) => child.name === "Initiation");

        if (!initiationNode) return [];

        const transactionBodyNode = initiationNode.findOne((n: any) => n.name === 'Transaction Body');
        if (transactionBodyNode) {
            const traverseResult = transactionBodyNode.children?.map((child: any) => traverseNode(child)) || []
            output = traverseResult.flat();
        }

        const actionSlotNode = initiationNode
            .findOne((n: any) => n.name === 'Transaction Header')
            ?.findOne((n: any) => n.name === 'Action Slot');

        if (actionSlotNode) {
            const buttonsChildren = actionSlotNode.children[0]?.children;
            for (let j = buttonsChildren.length - 1; j >= 0; j--) {
                const buttons = traverseNode(buttonsChildren[j]);
                if (buttons && typeof buttons === 'object' && 'buttonName' in buttons) {
                    const buttonOutput = generateButtonOutput(buttons);
                    if (buttonOutput) output.push(buttonOutput);
                } else {
                    console.error('Invalid or missing buttons object');
                }
            }
        }

        ensureBackButton(output);
        addDefaultButtonIfRequired(node, output);

        return output.length > 0 ? output : [];

    } catch (error) {
        console.error(error);
        return [];
    }
}

function generateButtonOutput(buttons: any) {
    switch (buttons.buttonName) {
        case 'primary':
            return { ...processButton(buttons, 'Submit'), hookFunctions: { code: "return true" } };
        case 'secondary':
            return processButton(buttons, 'Cancel');
        case 'tertiary':
            return processButton(buttons, 'Back');
        default:
            return null;
    }
}

function ensureBackButton(output: any[]) {
    if (!output.some((obj: any) => obj.buttonName === "tertiary")) {
        output.push({
            nameholder: "Back",
            selectionType: "custom",
            buttonName: "tertiary",
            valueClasses: "''",
            type: "Contract",
            componentID: `'${generate()}'`
        });
    }
}

function addDefaultButtonIfRequired(node: any, output: any[]) {
    if (node.componentProperties['Review Type']?.value === 'Default') {
        output.push({
            nameholder: "Confirm",
            selectionType: "custom",
            buttonName: "primary",
            valueClasses: "''",
            type: "Contract",
            componentID: `'${generate()}'`
        });
    }
}