export function setIgnoreKey(key: any) {
    const node = figma.currentPage?.selection[0];
    const jsonStr = node.getPluginData("ignoreNode");
    const ignoreArray = JSON.parse(jsonStr);
    ignoreArray.push(key);
    const updatedJsonStr = JSON.stringify(ignoreArray);
    node.setPluginData("ignoreNode", updatedJsonStr);
}

export function checkIgnoreKey(key: any) {
    const node = figma.currentPage?.selection[0];
    const jsonStr = node?.getPluginData("ignoreNode");
    const ignoreArray = jsonStr && JSON.parse(jsonStr);
    if (ignoreArray?.includes(key)) {
        return true
    }
    return false
}

export function removeIgnoreKey(key: any) {
    const node = figma.currentPage?.selection[0];
    const jsonStr = node?.getPluginData("ignoreNode");
    const ignoreArray = JSON.parse(jsonStr);
    const index = ignoreArray?.indexOf(key);
    if (index > -1) {
        ignoreArray?.splice(index, 1);
    }
    const updatedJsonStr = JSON.stringify(ignoreArray);
    node?.setPluginData("ignoreNode", updatedJsonStr);
}

//custom NLS - used in drawer heading
export function setCustomNLSKey(key: any) {
    const node = figma.currentPage?.selection[0];
    const jsonStr = node.getPluginData("customNLS");
    const customNLSArray = JSON.parse(jsonStr);
    customNLSArray.push(key);
    const updatedJsonStr = JSON.stringify(customNLSArray);
    node.setPluginData("customNLS", updatedJsonStr);
}