import { generate } from "../cleanFunc";
import { traverseNode } from "../traverseNode";
import { fetchOptions } from "./commonFunc";

export function generateTableProperties(node: any): any[] {
    return generateTableOptionList(node);
}

function generateTableOptionList(node: any): any {
    const tableHeaderQuantity = findTableQuantityNode(node);
    const options = tableHeaderQuantity?.children.flatMap((child: any) => {
        const result = fetchOptions(child);
        return result ? [result] : [];
    }) || [];

    const optionList = {
        optionSource: "custom",
        options: options
    };
    return { optionList }
}

function findTableQuantityNode(node: any) {
    return node.findOne((n: any) => n.name.replace(/\d+/g, '').trim() === "Table Header Container*");
}

function findColumns(node: any) {
    return node.findOne((n: any) => n.name.replace(/\d+/g, '').trim() === "Columns");
}

export function generateTableChildren(node: any) {
    const tableChildren = generateChildren(node);
    return tableChildren.length > 0 ? tableChildren : [];

}

function generateChildren(node: any) {
    const textOnly = node?.componentProperties['Text Only']?.value;
    if (textOnly && textOnly === 'False') {
        const columns = findColumns(node);
        if(columns){
            const rowNodes = (columns?.children || []).map((element: any) => {
                if (element?.visible === false) {
                    return null;
                }
                const dataOutput = traverseNode(element?.children[0]?.children[0]);
                if (Object.keys(dataOutput).length > 0) {
                    return {
                        "containerType": "TableData",
                        "template": "Container",
                        "valueClasses": "''",
                        "componentID": generate(),
                        "type": "Container",
                        "children": [dataOutput]
                    };
                }
                return null;
            }).filter(Boolean);

            if (rowNodes.length > 0) {
                return [
                    {
                        "containerType": "NormalContainer",
                        "subType": "slot",
                        "nameholder": "rowTemplate",
                        "title": "rowTemplate",
                        "componentID": generate(),
                        "type": "Container",
                        "children": [
                            {
                                "containerType": "TableRow",
                                "template": "Container",
                                "valueClasses": "''",
                                "componentID": generate(),
                                "type": "Container",
                                "children": rowNodes
                            }
                        ]
                    }
                ];
            }
        }
    }
    return [];
}