export function extractMinMax(node: any, type: 'min' | 'max'): string {
    const labels = node.findOne((n: any) => n.name === "Range Label")?.findAllWithCriteria({
        types: ['TEXT']
    });
    if (!labels || labels.length < 2) return '';
    const value = type === 'min' ? labels[0]?.characters : labels[1]?.characters;
    return value ? value.replace(/\D/g, "") : '';
}