import { connectedNodes, generateMappedValue, fetchOptions } from "./commonFunc";

export function generateRadioOrientation(node: any): string {
    const radioQuantity = node.findOne((n: any) => n.name.replace(/\d+/g, '').trim() === "Private/❗️Radio Quantity");
    const orientation = radioQuantity?.componentProperties['Orientation'].value.toLowerCase();
    return orientation === 'horizontal' ? "'oj-choice-direction-row'" : "'oj-choice-direction-column'";
}

export function generateRadioSetProperties(node: any): any[] {
    return generateRadioOptionList(node);
}

function generateRadioOptionList(node: any): any {
    const radioQuantity = findRadioQuantityNode(node);
    const options = radioQuantity?.children.flatMap((child: any) => {
        const result = fetchOptions(child, (output: any) => {
            if (output?.value) {
                return output.value;
            } else {
                throw new Error("Description not found or invalid");
            }
        });
        return result ? [result] : [];
    }) || [];


    const optionList = {
        optionSource: "custom",
        options: options
    };
    return {optionList}
}

export function radioConnectedNodes(node: any) {
    const radioQuantity = findRadioQuantityNode(node);
    const result = radioQuantity?.children.flatMap((child: any) => {
        const itemResult = connectedNodes(child, generateMappedValue(node), (output: any) => {
            if (output?.value) {
                return output.value;
            } else {
                throw new Error("Description not found or invalid");
            }
        });
        return itemResult ? [itemResult] : [];
    }) || [];

    return result;
}

function findRadioQuantityNode(node: any) {
    return node.findOne((n: any) => n.name.replace(/\d+/g, '').trim() === "Private/❗️Radio Quantity");
}