import { traverseNode } from "../traverseNode";

// Function to extract the heading from a node
function extractHeading(node: any): string {
    return node.findOne((n: any) => n.name.replace(/\d+/g, '').trim() === "Head")
        ?.findAllWithCriteria({ types: ['TEXT'] })[0]?.characters || '';
}

// Function to create a default form layout
function createFormLayout(): Record<string, string> {
    return {
        labelEdge: "inside",
        maxColumns: "1",
        direction: "row"
    };
}

// Function to determine if the page heading should be hidden
function shouldHidePageHeading(node: any): boolean {
    return node.componentProperties.hidePageHeading.value === 'True';
}

// Function to extract children nodes and process them
function extractChildren(node: any): any[] {
    const body = node.findOne((n: any) => n.name.replace(/\d+/g, '').trim() === "Body")?.children[0];

    return body?.children?.flatMap((child: any) => {
        if (!child.visible) {
            return [];
        }
        const childNodes = child.children?.map((childNode: any) => {
            if (!childNode.visible) {
                return [];
            }
            const output = traverseNode(childNode);

            if (Array.isArray(output)) {
                return output;
            } else if (output && Object.keys(output).length > 0) {
                return output;
            } else {
                return []; 
            }
        }) || [];

        return childNodes.flat(); 
    }) || [];
}

// Page Section mapping with improved readability
export const pageSectionMapping = {
    nameholder: {
        keyName: 'nameholder',
        value: (_value: any, node: Node) => extractHeading(node)
    },
    formLayout: {
        keyName: 'formLayout',
        value: createFormLayout
    },
    hidePageHeading: {
        keyName: 'hidePageHeading',
        value: (_value: any, node: Node) => shouldHidePageHeading(node)
    },
    children: {
        keyName: 'children',
        value: (_value: any, node: Node) => extractChildren(node)
    }
};
