type ComponentProperties = {
    [key: string]: {
        value: any;
        type: string;
    }
};

// export function camelCase(str: string): string {
//     return str
//         .replace(/(?:^\w|[A-Z]|\b\w)/g, (match, index) =>
//             index === 0 ? match.toLowerCase() : match.toUpperCase()
//         )
//         .replace(/[\s\W_]+/g, '');
// }

export function camelCase(name: string) {
    const words = name?.split(/[\s-]+/);
    let camelOutput = words[0]?.toLowerCase();
    for (let i = 1; i < words.length; i++) {
        camelOutput += words[i]?.charAt(0).toUpperCase() + words[i]?.slice(1).toLowerCase();
    }
    const output = camelOutput?.replace(/\d+/g, '');
    return output;
}

export function camelToHyphen(camelCaseString: string): string {
    return camelCaseString.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
}

export function cleanComponentProperties(properties: Record<string, any>): Record<string, any> {
    const cleanedProps: Record<string, any> = {};

    for (const key in properties) {
        if (properties.hasOwnProperty(key)) {
            const cleanedKey = key.replace(/[^a-zA-Z0-9]/g, '');
            const camelCaseKey = camelCase(cleanedKey.replace(/#\d+:\d+/g, ''));
            cleanedProps[camelCaseKey] = properties[key].value;
        }
    }

    return cleanedProps;
}


export function generate() {
    let length = 8;
    const characters = 'abcdefghijklmnopqrstuvwxyz';
    let result = '';
    const charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result +=
            characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
}

export function upperUnderscore(input: string) {
    return input.toUpperCase().replace(/ /g, '_');
}

export function lowerHyphen(input: string) {
    return input.toLowerCase().replace(/ /g, '-');
}