import { connectedNodes, fetchOptions, generateMappedValue } from "./commonFunc";

export function generateToggleButtonProperties(node: any): any[] {
    return toggleOption(node);
}

function toggleOption(node: any): any {
    const options = node?.children.flatMap((child: any) => {
        const result = fetchOptions(child, (output: any) => {
            if (output?.label) {
                return output.label;
            } else {
                throw new Error("Description not found or invalid");
            }
        });
        return result ? [result] : [];
    }) || [];

    const optionList = {
        optionSource: "custom",
        options: options
    };
    return {optionList}
}

export function toggleConnectedNodes(node: any) {
    const result = node?.children.flatMap((child: any) => {
        const itemResult = connectedNodes(child, generateMappedValue(node), (output: any) => {
            if (output?.label) {
                return output.label;
            } else {
                throw new Error("Description not found or invalid");
            }
        });
        return itemResult ? [itemResult] : [];
    }) || [];
    
    return result;
}