import { cleanComponentProperties, generate } from "../cleanFunc";
import { connectedNodes, fetchOptions, generateMappedValue } from "./commonFunc";

// Generate custom attributes for TabBar based on instance properties
export function generateCustomAttribute(node: any): string {
    const output = cleanComponentProperties(node.componentProperties);
    const attributes = [
        output.condensed === 'Yes' && 'oj-sm-condense',
        output.divider === 'Yes' && 'oj-divider-bottom',
    ];

    return attributes.filter(Boolean).join(' ').trim();
}

export function generateTabBarProperties(node: any): any[] {
    return tabBarOption(node);
}

function tabBarOption(node: any): any {
    const options = node?.children
        .filter((child: any) => child.visible !== false)
        .flatMap((child: any) => {
            const result = fetchOptions(child);
            return result ? [result] : [];
        }) || [];

    const optionList = {
        optionSource: "custom",
        options: options
    };
    return { optionList }
}

export function tabBarConnectedNodes(node: any) {
    const result = node?.children
        .filter((child: any) => child.visible !== false)
        .flatMap((child: any) => {
            const itemResult = connectedNodes(child, generateMappedValue(node));
            return itemResult ? [itemResult] : [];
        }) || [];

    return result;
}

// Generate tabBarResult from TabBar children
export function generateTabBarResult() {
    const result = [
        {
            nameholder: "itemTemplate",
            subType: "slot",
            containerType: "NormalContainer",
            valueClasses: "''",
            type: "Container",
            componentID: `itemTemplate${generate()}`,
            children: [
                {
                    nameholder: "Name",
                    mappedValue: "item.data.label",
                    use: "ObservableVariable",
                    valueClasses: "''",
                    className: "oj-md-12 oj-flex-item ",
                    tagType: "Span",
                    textBindingOption: "Bindings",
                    type: "Text",
                    componentID: `Name${generate()}`
                }
            ]
        }
    ]
    return result
}

