import { cleanComponentProperties, generate } from "../cleanFunc";
import { traverseNode } from "../traverseNode";

export function fetchChartType(node: any) {
    const cleanedProps = cleanComponentProperties(node.componentProperties);
    const chartType = cleanedProps?.charttype;
    return {
        "chartType": `''${chartType}''`,
        "chartTypeValue": `'${chartType}'`
    }
}

export function chartCustomAttributes(node: any) {
    const combinedProperties = {
        ...node.componentProperties,
        ...Object.assign({}, ...node.exposedInstances.map((instance: any) => instance.componentProperties))
    };
    const cleanedProps = cleanComponentProperties(combinedProperties);
    const chartType = cleanedProps?.charttype;
    let customAttributes: any = [];
    if (chartType === 'pie') {
        if (cleanedProps?.piecentrecontent === 'label') {
            customAttributes.push({
                attribute: 'pie-center.label',
                value: `'${cleanedProps?.piecentrelabel}'`
            })
        }

        if (cleanedProps?.showlegends) {
            customAttributes.push({
                attribute: 'legend.position',
                value: `'${cleanedProps?.legendposition}'`
            })
        }

        if (cleanedProps?.datalabels) {
            customAttributes.push({
                attribute: 'style-defaults.data-label-position',
                value: `'${cleanedProps?.datalabelposition}'`
            })
        }

        const pieComponent = node.findOne((n: any) => n.name === 'Pie');
        const layerOne = pieComponent?.findOne((n: any) => n.name === 'Layer 1');
        const innerRadius = layerOne?.arcData.innerRadius;
        if (innerRadius > 0) {
            customAttributes.push({
                attribute: 'style-defaults.pie-inner-radius',
                value: innerRadius
            })
        }

    } else if (chartType === 'line') {
        if (cleanedProps?.showlegends) {
            customAttributes.push({
                attribute: 'legend.position',
                value: `'${cleanedProps?.legendposition}'`
            })
        }

        customAttributes.push(
            {
                attribute: 'style-defaults.line-type',
                value: `'${cleanedProps?.linetype}'`
            },
            {
                "attribute": "orientation",
                "value": "'vertical'"
            })
    } else if (chartType === 'bar') {
        if (cleanedProps?.showlegends) {
            customAttributes.push({
                attribute: 'legend.position',
                value: `'${cleanedProps?.legendposition}'`
            })
        }
        if (cleanedProps?.stacked) {
            customAttributes.push({
                attribute: 'stack',
                value: `'on'`
            })
        } else {
            customAttributes.push({
                attribute: 'stack',
                value: `'off'`
            })
        }

        customAttributes.push(
            {
                "attribute": "orientation",
                "value": `'${cleanedProps?.orientation}'`
            })
    }

    return customAttributes;
}

export function templateSlots(node: any) {
    const combinedProperties = {
        ...node.componentProperties,
        ...Object.assign({}, ...node.exposedInstances.map((instance: any) => instance.componentProperties))
    };
    const cleanedProps = cleanComponentProperties(combinedProperties);
    const chartType = cleanedProps?.charttype;

    if (chartType === 'pie') {
        if (cleanedProps?.piecentrecontent === 'slot') {
            return [{
                slotName: 'pieCenterTemplate'
            }]
        }
    }
    return;
}

export function slotsFunc(node: any) {
    const combinedProperties = {
        ...node.componentProperties,
        ...Object.assign({}, ...node.exposedInstances.map((instance: any) => instance.componentProperties))
    };
    const cleanedProps = cleanComponentProperties(combinedProperties);
    const chartType = cleanedProps?.charttype;

    if (chartType === 'pie') {
        if (cleanedProps?.piecentrecontent === 'slot') {
            return [
                {
                    "name": "groupTemplate"
                },
                {
                    "name": "itemTemplate",
                    "index": 1
                },
                {
                    "name": "pieCenterTemplate",
                    "index": 2
                },
                {
                    "name": "seriesTemplate",
                    "index": 3
                },
                {
                    "name": "tooltipTemplate",
                    "index": 4
                }
            ]
        }
    }
    return;
}

export function slotChildren(node: any) {
    const combinedProperties = {
        ...node.componentProperties,
        ...Object.assign({}, ...node.exposedInstances.map((instance: any) => instance.componentProperties))
    };
    const cleanedProps = cleanComponentProperties(combinedProperties);
    const chartType = cleanedProps?.charttype;

    if (chartType === 'pie') {
        if (cleanedProps?.piecentrecontent === 'slot') {
            const pieComponent = node.findOne((n: any) => n.name === 'Pie');
            const pieCentreTemplate = pieComponent?.findOne((n: any) => n.name === 'pieCentreTemplate');
            let output: any[] = [];
            if (pieCentreTemplate) {
                const traverseResult = pieCentreTemplate?.children?.map(traverseNode) || [];
                output = traverseResult.flat();
            }
            if (output.length > 0) {
                return [{
                    "containerType": "NormalContainer",
                    "subType": "slot",
                    "nameholder": "pieCenterTemplate",
                    "title": "pieCenterTemplate",
                    "componentID": `'${generate()}'`,
                    "type": "Container",
                    "children": output
                }]
            }
        }
    }
    return;
}
