import { useAppContext } from '../../context/AppContext';
import "ojs/ojbutton";
import ContainerComponent from '../utility/ContainerComponent';
import Header from '../utility/Header';

export function UpdateOverwrite(props: any) {
    const { handleExport, handleUpdate } = props;
    const { setType, formData, setFormData } = useAppContext();
    const componentDescription = formData.componentDescription;

    const handleBack = () => {
        setFormData({
            ...formData,
            menuEntry: false
        });
        setType("export");
    }

    return (
        <>
            <ContainerComponent>
                <Header title='Export to toolkit' handleBack={handleBack} />
                <div style={{ display: "flex", flexDirection: "column", justifyContent: "center", flexGrow: 1, alignContent: 'center' }}>
                    <p style={{ textAlign: 'center' }}>The component '{componentDescription}' already exists. Would you like you update the layout of the existing component or overwrite the entire component</p>
                    <div class="oj-sm-margin-2x">
                        <oj-button class="oj-button-md oj-button-full-width oj-sm-margin-2x-bottom" chroming="outlined" label="Update" onojAction={handleUpdate} />
                        <div style={styles.overwriteContainer}>
                            <oj-button class="oj-button-md oj-button-full-width" chroming="outlined" label="Overwrite" onojAction={handleExport} />
                            <div style={styles.arrow}></div>
                            <div style={styles.disclaimer}>
                                Caution: Overwriting will replace entire existing metadata including any APIs attached, conditions, etc
                            </div>
                        </div>
                    </div>
                </div>
            </ContainerComponent>
        </>
    )
}

const styles = {
    overwriteContainer: {
        display: 'flex',
        flexDirection: 'column',
        position: 'relative'
    },
    arrow: {
        width: 0,
        height: 0,
        borderLeft: '5px solid transparent',
        borderRight: '5px solid transparent',
        borderBottom: '10px solid #F0A957',
        opacity: '0.4',
        marginLeft: "10px"
    },
    disclaimer: {
        position: 'relative',
        backgroundColor: "rgba(240, 169, 87, .4)",
        color: "#8F520A",
        padding: "5px 10px",
        border: "1px solid #f5c6cb",
        borderRadius: "4px",
        whiteSpace: 'pre-wrap',
        fontSize: "0.875rem",
    }
}