import "ojs/ojactioncard";
import "ojs/ojbutton";
import { useAppContext } from '../../context/AppContext';
import ContainerComponent from "../utility/ContainerComponent";
import 'ojs/ojactioncard';
import createImg from "../images/create.png"
import modifyImg from "../images/modify.png"
import templateImg from "../images/template.svg"
import export1 from "../images/export1.svg"
import export2 from "../images/export2.svg"
import export3 from "../images/export3.svg"
export function MainPage() {

    const { setType } = useAppContext();
    const typeClick = (type: string) => {
        if (type === 'template') {
            parent.postMessage({ pluginMessage: { type: 'template' } }, '*');
        }
        setType(type);
    };

    return (
        <>
            {/* <ContainerComponent>
                <div class="oj-flex oj-sm-flex-direction-row oj-sm-flex-items-1 oj-sm-margin-2x-bottom oj-lg-justify-content-space-around" style={{ flex: "2" }}>
                    <div class="oj-flex-item oj-sm-margin-1x-end">
                        <oj-action-card style={{ width: "100%", height: "100%" }}
                            id="Default"
                            onClick={() => typeClick("create")}
                            class="oj-bg-info-30 oj-sm-align-items-center oj-sm-justify-content-center oj-sm-flex-direction-column">
                            <div class="oj-ux-ico-plus-circle oj-ux-icon-size-6x" role="img" aria-label="create"></div>
                            <div class="oj-typography-body-md">
                                Create New
                            </div>
                        </oj-action-card>
                    </div>
                    <div class="oj-flex-item oj-sm-margin-1x-start">
                        <oj-action-card style={{ width: "100%", height: "100%" }}
                            id="Default"
                            onClick={() => typeClick("generate")}
                            class="oj-bg-warning-30 oj-sm-align-items-center oj-sm-justify-content-center oj-sm-flex-direction-column">
                            <div class="oj-ux-ico-flash-on oj-ux-icon-size-6x" role="img" aria-label="generate"></div>
                            Generate from existing
                        </oj-action-card>
                    </div>
                </div>
                <div class="oj-flex-item" style={{ flex: 1 }}>
                    <oj-action-card style={{ width: "100%", height: "100%" }}
                        id="Default"
                        onClick={() => typeClick("export")}
                        class="oj-bg-success-30 oj-sm-align-items-center oj-sm-justify-content-center">
                        <div class="oj-ux-ico-upload oj-ux-icon-size-6x oj-sm-margin-2x-end" role="img" aria-label="export"></div>
                        Export
                    </oj-action-card>
                </div>
            </ContainerComponent> */}

            <div style={styles.gridContainer}>
                <oj-action-card style={styles.card}
                    id="Default"
                    onClick={() => typeClick("create")}>
                    <div style={styles.imageContainer}>
                        <img style={styles.cardImage} src={createImg} alt="Create New Design" />
                    </div>
                    <p style={styles.cardText}>Create New Design</p>
                </oj-action-card>
                <oj-action-card style={styles.card}
                    id="Default"
                    onClick={() => typeClick("generate")}>
                    <div style={styles.imageContainer}>
                        <img style={styles.cardImage} src={modifyImg} alt="Modify Component" />
                    </div>
                    <p style={styles.cardText}>Modify Component</p>
                </oj-action-card>
                <oj-action-card style={styles.card}
                    id="Default"
                    onClick={() => typeClick("template")}>
                    <div style={styles.imageContainer}>
                        <img style={styles.cardImage} src={templateImg} alt="Convert to Template" />
                    </div>
                    <p style={styles.cardText}>Convert to Template</p>
                </oj-action-card>
                <oj-action-card style={styles.card}
                    id="Default"
                    onClick={() => typeClick("export")}>
                    <div style={styles.imageContainer}>
                        <img style={{ ...styles.exportImage, marginRight: "8px" }} src={export1} alt="Export 1" />
                        <img style={{ ...styles.exportImage, position: 'absolute', top: '28%', left: '42%', zIndex: 1, width: "18%" }} src={export2} alt="Export 2" />
                        <img style={{ ...styles.exportImage, marginLeft: "8px" }} src={export3} alt="Export 3" />
                    </div>

                    <p style={styles.cardText}>Export to Toolkit</p>
                </oj-action-card>
            </div>
        </>
    )
}


const styles = {
    gridContainer: {
        display: 'flex',
        flexWrap: 'wrap',
        justifyContent: 'space-between',
        gap: '15px',
        width: '100%',
        padding: '15px',
        height: '100vh',
        boxSizing: 'border-box',
    },
    card: {
        flex: '1 1 calc(50% - 20px)',
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'center',
        alignItems: 'center',
        background: 'linear-gradient(134.26deg, rgba(190, 204, 255, 0.7) 1.36%, #FFFFFF 70.29%)',
        borderImageSlice: 1,
        borderRadius: '10px',
        padding: '5px',
        textAlign: 'center',
        boxSizing: 'border-box',
    },
    imageContainer: {
        width: '100%',
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
        position: 'relative'
    },
    cardImage: {
        maxWidth: '100%',
        height: 'auto',
        marginBottom: '10px',
    },
    exportImage: {
        maxWidth: '44%',
        height: 'auto',
        marginBottom: '10px',
        marginTop: '10px'

    },
    cardText: {
        fontSize: '16px',
        fontWeight: 700,
        color: '#333',
    },
};


