export function childFlexType(node: any) {
    const layoutMode = node.parent.layoutMode;
    const layoutSizing =
        layoutMode === 'HORIZONTAL' ? node.layoutSizingHorizontal :
            layoutMode === 'VERTICAL' ? node.layoutSizingVertical : '';

    let flexType =
        layoutSizing === 'HUG' ? ' oj-sm-flex-initial oj-flex-item' :
            layoutSizing === 'FILL' ? ' oj-sm-flex-1 oj-flex-item' : '';

    if (layoutMode === "VERTICAL" && node.layoutSizingHorizontal === 'FILL') {
        flexType = flexType + ' oj-sm-width-full'
    }

    return flexType;
}

function alignMapping(key: string): string | undefined {
    const mapping: Record<string, string> = {
        MIN: " oj-sm-align-items-flex-start",
        CENTER: " oj-sm-align-items-center",
        MAX: " oj-sm-align-items-flex-end",
    };
    return mapping[key];
}

function justifyMapping(key: string): string | undefined {
    const mapping: Record<string, string> = {
        MIN: " oj-sm-justify-content-flex-start",
        CENTER: " oj-sm-justify-content-center",
        MAX: " oj-sm-justify-content-flex-end",
        SPACE_BETWEEN: " oj-sm-justify-content-space-between",
    };
    return mapping[key];
}

interface Node {
    layoutMode: string;
    layoutWrap?: string;
    counterAxisAlignItems?: string;
    primaryAxisAlignItems?: string;
    itemSpacing?: number;
    paddingLeft?: number;
    paddingRight?: number;
    paddingTop?: number;
    paddingBottom?: number;
    boundVariables?: any;
    layoutSizingVertical?: string;
}

export function parentFlexType(node: Node): string {
    const {
        layoutMode,
        layoutWrap,
        counterAxisAlignItems,
        primaryAxisAlignItems,
        itemSpacing,
        paddingLeft = 0,
        paddingRight = 0,
        paddingTop = 0,
        paddingBottom = 0,
        boundVariables,
        layoutSizingVertical
    } = node;

    const columnFlex = layoutMode === "VERTICAL" ? " oj-sm-flex-direction-column" : "";
    const layoutWrapClass =
        (layoutMode === "HORIZONTAL" && layoutWrap === "NO_WRAP") ||
            (layoutMode === "VERTICAL" && layoutSizingVertical === "FIXED")
            ? " oj-sm-flex-wrap-nowrap"
            : "";

    const alignItemsClass = alignMapping(counterAxisAlignItems ?? "") || "";
    let justifyContentClass = justifyMapping(primaryAxisAlignItems ?? "") || "";

    const boundVars = boundVariables;
    let gapSpacing: string = '';

    if (
        ((layoutMode === "HORIZONTAL" && itemSpacing === paddingLeft + paddingRight) ||
            (layoutMode === "VERTICAL" && itemSpacing === paddingTop + paddingBottom)) && itemSpacing !== 0
    ) {
        justifyContentClass = " oj-sm-justify-content-space-around";
    } else if (boundVars && boundVars.itemSpacing) {
        const itemVar = boundVars.itemSpacing?.id;
        const variable = figma.variables.getVariableById(itemVar);

        if (variable) {
            if (layoutMode === "HORIZONTAL" && layoutWrap === "NO_WRAP") {
                gapSpacing = ` gap-sm-${variable.name}-column`;
            } else if (layoutMode === "VERTICAL") {
                gapSpacing = ` gap-sm-${variable.name}-row`;
            } else {
                gapSpacing = ` gap-sm-${variable.name}`;
            }
        } else {
            gapSpacing = '';
        }
    }


    return `${columnFlex}${layoutWrapClass}${alignItemsClass}${justifyContentClass}${gapSpacing}`;
}
