import { cleanComponentProperties } from "../cleanFunc";

export function mapAvatarSize(value: string): string {
    const sizeMapping: Record<string, string> = {
        '2xl': 'xxl',
        '2xs': 'xxs',
    };

    const avatar = (value?.split('/')[1] || 'xs').toLowerCase();
    const avatarSize = sizeMapping[avatar] || avatar
    return `'${avatarSize}'`;
}


export function fetchIconClass(value: string, node: any){
    const cleanedProps = cleanComponentProperties(node.componentProperties);
    const type = cleanedProps['type'];
    if(value && type==='Icon'){
        const iconName = figma.getNodeById(value)?.parent?.name;
        return `oj-ux-ico-${iconName}`;
    }
}