define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"List of Examples",
                    "href":"loe.html"
                },
                {
                    "title":"List of Figures",
                    "href":"lof.html"
                },
                {
                    "title":"List of Tables",
                    "href":"lot.html"
                },
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Get Started",
                    "href":"get-started.html",
                    "topics":[
                        {
                            "title":"Getting started with Oracle NoSQL Database",
                            "href":"getting-started-oracle-nosql-database1.html",
                            "topics":[
                                {
                                    "title":"Start your data store",
                                    "href":"start-your-data-store.html"
                                },
                                {
                                    "title":"Starting the SQL shell",
                                    "href":"starting-sql-shell.html"
                                },
                                {
                                    "title":"Sample use-cases used in the examples",
                                    "href":"sample-use-cases-used-examples.html"
                                },
                                {
                                    "title":"Tables used in the examples",
                                    "href":"tables-used-examples.html"
                                },
                                {
                                    "title":"Describe tables",
                                    "href":"describe-tables.html"
                                },
                                {
                                    "title":"Sample data to run queries",
                                    "href":"sample-data-run-queries.html"
                                },
                                {
                                    "title":"Table Hierarchies",
                                    "href":"table-hierarchies.html"
                                },
                                {
                                    "title":"About Oracle NoSQL Database SDK drivers",
                                    "href":"oracle-nosql-database-sdk-drivers.html"
                                },
                                {
                                    "title":"Obtaining a NoSQL Handle",
                                    "href":"obtaining-nosql-handle.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Create",
                    "href":"create.html",
                    "topics":[
                        {
                            "title":"Creating a namespace",
                            "href":"creating-namespace.html"
                        },
                        {
                            "title":"Creating a region",
                            "href":"creating-region.html"
                        },
                        {
                            "title":"Creating a table",
                            "href":"creating-table.html",
                            "topics":[
                                {
                                    "title":"Using SQL commands",
                                    "href":"using-sql-commands-create-table.html"
                                },
                                {
                                    "title":"Using TableRequest API",
                                    "href":"using-tablerequest-api-create-table.html"
                                }
                            ]
                        },
                        {
                            "title":"Create and View Indexes",
                            "href":"create-and-view-indexes1.html",
                            "topics":[
                                {
                                    "title":"Classification of Indexes",
                                    "href":"classification-indexes.html"
                                },
                                {
                                    "title":"Creating Indexes",
                                    "href":"creating-indexes.html",
                                    "topics":[
                                        {
                                            "title":"Using SQL commands",
                                            "href":"using-sql-commands-create-index.html"
                                        },
                                        {
                                            "title":"Using TableRequest API",
                                            "href":"using-tablerequest-api-create-index.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"View Index",
                                    "href":"view-index.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Manage",
                    "href":"manage.html",
                    "topics":[
                        {
                            "title":"Namespace Management",
                            "href":"namespace-management1.html",
                            "topics":[
                                {
                                    "title":"Namespace Resolution",
                                    "href":"namespace-resolution.html"
                                },
                                {
                                    "title":"Manage Namespaces",
                                    "href":"manage-namespaces.html"
                                },
                                {
                                    "title":"Namespace scoped privileges",
                                    "href":"namespace-scoped-privileges.html"
                                },
                                {
                                    "title":"Granting Authorization Access to Namespaces",
                                    "href":"granting-authorization-access-namespaces.html"
                                }
                            ]
                        },
                        {
                            "title":"Managing Tables, Indexes & Regions",
                            "href":"managing-tables-indexes-regions1.html",
                            "topics":[
                                {
                                    "title":"Alter Table",
                                    "href":"alter-table.html",
                                    "topics":[
                                        {
                                            "title":"Using SQL command to alter table",
                                            "href":"using-sql-command-alter-table.html"
                                        },
                                        {
                                            "title":"Using TableRequest API to alter table",
                                            "href":"using-tablerequest-api-alter-table.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Drop Table",
                                    "href":"drop-table.html",
                                    "topics":[
                                        {
                                            "title":"Using SQL command to drop table",
                                            "href":"using-sql-command-drop-table.html"
                                        },
                                        {
                                            "title":"Using TableRequest API to drop table",
                                            "href":"using-tablerequest-api-drop-table.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Drop Index",
                                    "href":"drop-index.html",
                                    "topics":[
                                        {
                                            "title":"Using SQL command to drop index",
                                            "href":"using-sql-command-drop-index.html"
                                        },
                                        {
                                            "title":"Using TableRequest API to drop index",
                                            "href":"using-tablerequest-api-drop-index.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Manage regions",
                                    "href":"manage-regions.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Develop",
                    "href":"develop.html",
                    "topics":[
                        {
                            "title":"Inserting, Modifying, and Deleting Data",
                            "href":"inserting-modifying-and-deleting-data1.html",
                            "topics":[
                                {
                                    "title":"Insert data",
                                    "href":"insert-data.html",
                                    "topics":[
                                        {
                                            "title":"Using SQL command to insert data",
                                            "href":"using-sql-command-insert-data.html"
                                        },
                                        {
                                            "title":"Using Put API to insert data",
                                            "href":"using-put-api-insert-data.html"
                                        },
                                        {
                                            "title":"Using MultiWrite API to insert data",
                                            "href":"using-multiwrite-api-insert-data.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Upsert Data",
                                    "href":"upsert-data.html",
                                    "topics":[
                                        {
                                            "title":"Using SQL command to upsert data",
                                            "href":"using-sql-command-upsert-data.html"
                                        },
                                        {
                                            "title":"Using API to upsert data",
                                            "href":"using-api-upsert-data.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Update Data",
                                    "href":"update-data.html",
                                    "topics":[
                                        {
                                            "title":"Using SQL command to update data",
                                            "href":"using-sql-command-update-data.html"
                                        },
                                        {
                                            "title":"Using API to update data",
                                            "href":"using-api-update-data.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Modify JSON data",
                                    "href":"modify-json-data.html",
                                    "topics":[
                                        {
                                            "title":"Using SQL command",
                                            "href":"using-sql-command-modify-json-data.html"
                                        },
                                        {
                                            "title":"Using API",
                                            "href":"using-api-modify-json-data.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Delete Data",
                                    "href":"delete-data.html",
                                    "topics":[
                                        {
                                            "title":"Using SQL command to delete data",
                                            "href":"using-sql-command-delete-data.html"
                                        },
                                        {
                                            "title":"Using API to delete a single row",
                                            "href":"using-api-delete-single-row.html"
                                        },
                                        {
                                            "title":"Using API to delete multiple rows",
                                            "href":"using-api-delete-multiple-rows.html"
                                        },
                                        {
                                            "title":"Using Query API to delete data",
                                            "href":"using-query-api-delete-data.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Simple SELECT queries",
                            "href":"simple-select-queries1.html",
                            "topics":[
                                {
                                    "title":"Using SQL commands to fetch data",
                                    "href":"using-sql-commands-fetch-data.html"
                                },
                                {
                                    "title":"Substituting column names in a query",
                                    "href":"substituting-column-names-query.html"
                                },
                                {
                                    "title":"Using Get API to fetch data",
                                    "href":"using-get-api-fetch-data.html"
                                },
                                {
                                    "title":"Using Query API to fetch data",
                                    "href":"using-query-api-fetch-data.html"
                                }
                            ]
                        },
                        {
                            "title":"SELECT queries on JSON collection tables",
                            "href":"managing-json-collection-tables1.html#GUID-6C7B3535-B383-422B-B210-3F6F8DB99AA7"
                        },
                        {
                            "title":"Using Path expressions",
                            "href":"using-path-expressions1.html",
                            "topics":[
                                {
                                    "title":"Using Internal variables and aliases",
                                    "href":"using-internal-variables-and-aliases.html"
                                },
                                {
                                    "title":"Working with Arrays",
                                    "href":"working-arrays.html"
                                },
                                {
                                    "title":"Working with nested data type",
                                    "href":"working-nested-data-type.html"
                                },
                                {
                                    "title":"Finding the size of a complex data type",
                                    "href":"finding-size-complex-data-type.html"
                                }
                            ]
                        },
                        {
                            "title":"Using user-defined row metadata",
                            "href":"using-user-defined-row-metadata1.html",
                            "topics":[
                                {
                                    "title":"Using row metadata in Write Operations",
                                    "href":"using-row-metadata-write-operations.html"
                                },
                                {
                                    "title":"Using row metadata in Read Operations",
                                    "href":"using-row-metadata-read-operations.html"
                                },
                                {
                                    "title":"Using SQL commands on row metadata",
                                    "href":"using-sql-commands-row-metadata.html"
                                }
                            ]
                        },
                        {
                            "title":"Using Left Outer joins with parent-child tables",
                            "href":"using-left-outer-joins-parent-child-tables1.html",
                            "topics":[
                                {
                                    "title":"Overview of Left Outer Joins",
                                    "href":"overview-left-outer-joins.html"
                                },
                                {
                                    "title":"Examples using Left Outer Joins",
                                    "href":"examples-using-left-outer-joins.html",
                                    "topics":[
                                        {
                                            "title":"SQL Examples",
                                            "href":"sql-examples-loj.html"
                                        },
                                        {
                                            "title":"Query API examples",
                                            "href":"query-api-examples-loj.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Using NESTED TABLES to join parent-child tables",
                            "href":"using-nested-tables-join-parent-child-tables1.html",
                            "topics":[
                                {
                                    "title":"Overview of NESTED TABLES",
                                    "href":"overview-nested-tables.html"
                                },
                                {
                                    "title":"Examples using NESTED TABLES",
                                    "href":"examples-using-nested-tables.html",
                                    "topics":[
                                        {
                                            "title":"SQL Examples",
                                            "href":"sql-examples-nested-tables.html"
                                        },
                                        {
                                            "title":"Query API examples",
                                            "href":"query-api-examples-nested-tables.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Using inner join with parent-child tables",
                            "href":"using-inner-join-parent-child-tables.html",
                            "topics":[
                                {
                                    "title":"Overview of Inner Join",
                                    "href":"overview-inner-join.html"
                                },
                                {
                                    "title":"Examples using Inner Join",
                                    "href":"examples-using-inner-join.html",
                                    "topics":[
                                        {
                                            "title":"SQL Examples",
                                            "href":"sql-examples.html"
                                        },
                                        {
                                            "title":"Query API Examples",
                                            "href":"query-api-examples.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Tuning and Optimizing SQL queries",
                            "href":"tuning-and-optimizing-sql-queries1.html",
                            "topics":[
                                {
                                    "title":"Using Indexes for query optimization",
                                    "href":"using-indexes-query-optimization.html"
                                },
                                {
                                    "title":"Examples of queries using index",
                                    "href":"examples-queries-using-index.html"
                                }
                            ]
                        },
                        {
                            "title":"Managing GeoJSON data",
                            "href":"managing-geojson-data1.html",
                            "topics":[
                                {
                                    "title":"geo_inside",
                                    "href":"geo_inside.html"
                                },
                                {
                                    "title":"geo_intersect",
                                    "href":"geo_intersect.html"
                                },
                                {
                                    "title":"geo_distance",
                                    "href":"geo_distance.html"
                                },
                                {
                                    "title":"geo_within_distance",
                                    "href":"geo_within_distance.html"
                                },
                                {
                                    "title":"geo_near",
                                    "href":"geo_near.html"
                                },
                                {
                                    "title":"geo_is_geometry",
                                    "href":"geo_is_geometry.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Reference",
                    "href":"reference.html",
                    "topics":[
                        {
                            "title":"Operators in SQL",
                            "href":"operators-sql1.html",
                            "topics":[
                                {
                                    "title":"Sequence Comparison Operators",
                                    "href":"sequence-comparison-operators.html"
                                },
                                {
                                    "title":"Logical operators",
                                    "href":"logical-operators.html"
                                },
                                {
                                    "title":"NULL operators",
                                    "href":"null-operators.html"
                                },
                                {
                                    "title":"Value Comparison Operators",
                                    "href":"value-comparison-operators.html"
                                },
                                {
                                    "title":"BETWEEN Operator",
                                    "href":"operator1.html"
                                },
                                {
                                    "title":"IN Operator",
                                    "href":"operator.html"
                                },
                                {
                                    "title":"Regular Expression Conditions",
                                    "href":"regular-expression-conditions.html"
                                },
                                {
                                    "title":"EXISTS Operator",
                                    "href":"exists-operator.html"
                                },
                                {
                                    "title":"Is-Of-Type Operator",
                                    "href":"is-type-operator.html"
                                },
                                {
                                    "title":"SQL Operators examples using QueryRequest API",
                                    "href":"sql-operators-examples-using-queryrequest-api.html"
                                }
                            ]
                        },
                        {
                            "title":"Sorting, Grouping & Limiting results",
                            "href":"sorting-grouping-and-limiting-results.html",
                            "topics":[
                                {
                                    "title":"Ordering results",
                                    "href":"ordering-results.html"
                                },
                                {
                                    "title":"Limit and offset results",
                                    "href":"limit-and-offset-results.html"
                                },
                                {
                                    "title":"Grouping results",
                                    "href":"grouping-results.html"
                                },
                                {
                                    "title":"Aggregating results",
                                    "href":"aggregating-results.html"
                                },
                                {
                                    "title":"Examples using QueryRequest API",
                                    "href":"examples-using-queryrequest-api.html"
                                }
                            ]
                        },
                        {
                            "title":"Primary Expressions in SQL",
                            "href":"primary-expressions-sql1.html",
                            "topics":[
                                {
                                    "title":"Parenthesized Expressions",
                                    "href":"parenthesized-expressions.html"
                                },
                                {
                                    "title":"Case Expressions",
                                    "href":"case-expressions.html"
                                },
                                {
                                    "title":"Cast Expression",
                                    "href":"cast-expression.html"
                                },
                                {
                                    "title":"Sequence Transform Expressions",
                                    "href":"sequence-transform-expressions.html"
                                },
                                {
                                    "title":"Extract Expressions",
                                    "href":"extract-expressions.html"
                                },
                                {
                                    "title":"SQL Expression examples using QueryRequest API",
                                    "href":"sql-expression-examples-using-queryrequest-api.html"
                                }
                            ]
                        },
                        {
                            "title":"Timestamp Functions",
                            "href":"timestamp-functions1.html",
                            "topics":[
                                {
                                    "title":"Timestamp Arithmetic Functions",
                                    "href":"timestamp_add-function.html"
                                },
                                {
                                    "title":"Timestamp Round Functions",
                                    "href":"timestamp-round-functions.html"
                                },
                                {
                                    "title":"Timestamp Format Functions",
                                    "href":"timestamp-format-functions.html"
                                },
                                {
                                    "title":"Timestamp Extract Functions",
                                    "href":"timestamp-extract-functions.html"
                                },
                                {
                                    "title":"Current Time Functions",
                                    "href":"current-time-functions.html"
                                },
                                {
                                    "title":"Examples using QueryRequest API",
                                    "href":"sql-timestamp-functions-examples-using-queryrequest-api.html"
                                }
                            ]
                        },
                        {
                            "title":"Functions on Strings",
                            "href":"functions-strings1.html",
                            "topics":[
                                {
                                    "title":"substring function",
                                    "href":"substring-function.html"
                                },
                                {
                                    "title":"concat function",
                                    "href":"concat-function.html"
                                },
                                {
                                    "title":"upper and lower functions",
                                    "href":"upper-and-lower-functions.html"
                                },
                                {
                                    "title":"trim function",
                                    "href":"trim-function.html"
                                },
                                {
                                    "title":"length function",
                                    "href":"length-function.html"
                                },
                                {
                                    "title":"contains function",
                                    "href":"contains-function.html"
                                },
                                {
                                    "title":"starts_with and ends_with functions",
                                    "href":"starts_with-and-end_with-functions.html"
                                },
                                {
                                    "title":"index_of function",
                                    "href":"index_of-function.html"
                                },
                                {
                                    "title":"replace function",
                                    "href":"replace-function.html"
                                },
                                {
                                    "title":"reverse function",
                                    "href":"reverse-function.html"
                                },
                                {
                                    "title":"Examples using QueryRequest API",
                                    "href":"sql-string-functions-examples-using-queryrequest-api.html"
                                }
                            ]
                        },
                        {
                            "title":"Query execution plan",
                            "href":"query-execution-plan1.html",
                            "topics":[
                                {
                                    "title":"Overview of query plan",
                                    "href":"overview-query-plan.html"
                                },
                                {
                                    "title":"Query 1: Using primary key index with an index range scan",
                                    "href":"query-1-using-primary-key-index-index-range-scan.html"
                                },
                                {
                                    "title":"Query 2: Using primary key index with an index predicate",
                                    "href":"query-2-using-primary-key-index-index-predicate.html"
                                },
                                {
                                    "title":"Query 3: Using a secondary index with an index range scan",
                                    "href":"query-3-using-secondary-index-index-range-scan.html"
                                },
                                {
                                    "title":"Query 4: Using the primary index",
                                    "href":"query-4-using-primary-index.html"
                                },
                                {
                                    "title":"Query 5: Sort the data using a Covering index",
                                    "href":"query-5-sort-data-using-covering-index.html"
                                },
                                {
                                    "title":"Query 6: Using a secondary index with an index predicate",
                                    "href":"query-6-using-secondary-index-index-predicate.html"
                                },
                                {
                                    "title":"Query 7: Group data with fields as part of the index",
                                    "href":"query-7-group-data-fields-part-index.html"
                                },
                                {
                                    "title":"Query 8: Using the secondary index with multiple index scans",
                                    "href":"query-8-using-secondary-index-multiple-index-scans.html"
                                },
                                {
                                    "title":"Query 9: A SINGLE PARTITION query using a primary index",
                                    "href":"query-9-single-partition-query-using-primary-index.html"
                                },
                                {
                                    "title":"Query 10: Group data with fields not part of any index",
                                    "href":"query-10-group-data-fields-not-part-any-index.html"
                                }
                            ]
                        },
                        {
                            "title":"Table Modelling and Design",
                            "href":"table-modelling-and-design1.html",
                            "topics":[
                                {
                                    "title":"Schema Flexibility in Oracle NoSQL Database",
                                    "href":"schema-flexibility-oracle-nosql-database.html"
                                },
                                {
                                    "title":"Choice of Keys in NoSQL Database",
                                    "href":"choice-keys-nosql-database.html"
                                },
                                {
                                    "title":"Using Indexes in NoSQL Database",
                                    "href":"using-indexes-nosql-database.html"
                                },
                                {
                                    "title":"Transactions in NoSQL database",
                                    "href":"transactions-nosql-database.html"
                                }
                            ]
                        },
                        {
                            "title":"Handling Errors",
                            "href":"handling-errors2.html",
                            "topics":[
                                {
                                    "title":"Handling Driver Errors",
                                    "href":"handling-errors1.html"
                                }
                            ]
                        }
                    ]
                }
            ]
        }
    ]
});